partial class EditCustomers : ApplicationBasePage
{

#region  Page Events 

    /// <summary>
    /// Wire up the rest of the events used within the page.  This event is intrinsically called
    /// since the AutoEventWireUp tag is set in the SearchCustomers.aspx source (top of the source).
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
	protected void Page_Load(object sender, System.EventArgs e)
	{
        //-- Wireup the remainder of the events
        cmdFirst.Click += new System.Web.UI.ImageClickEventHandler(cmdFirst_Click);
        cmdLast.Click += new System.Web.UI.ImageClickEventHandler(cmdLast_Click);
        cmdNext.Click += new System.Web.UI.ImageClickEventHandler(cmdNext_Click);
        cmdPrevious.Click += new System.Web.UI.ImageClickEventHandler(cmdPrevious_Click);
        cmdAdd.Click += new System.EventHandler(cmdAdd_Click);
        cmdEdit.Click += new System.EventHandler(cmdEdit_Click);
        cmdDelete.Click += new System.EventHandler(cmdDelete_Click);
        cmdSave.Click += new System.EventHandler(cmdSave_Click);
        cmdUndo.Click += new System.EventHandler(cmdUndo_Click);


		//-- If no data exists within the BO, load the top 100 records
		if (Customers.Count == 0)
		{
			Customers.FillTop100();
		}

		//-- Set the UI Readonly State
		if (this.IsPostBack)
		{
			SetUIReadonly();
		}

		//-- Set the smart navigation
		//Me.SmartNavigation = True

		//-- See if a PK was passed
		if ((this.Request["pk"] != null) && (! this.IsPostBack))
		{
			Customers.NavigateToPrimaryKey(System.Convert.ToInt32(this.Request["pk"]));
			Customers.Edit();
			this.txtFirstName.Focus();
		}

		//-- Set the state of the buttons
		SetButtonState();
	}

#endregion

#region  Private Methods 

	/// <summary>
	/// Dynamically swaps between allowing the BO to control the readonly state
	/// and not.  Normally this is not done automatically and can be controlled before 
	/// run-time by setting the IgnoreUIReadonlyState property on a control or the ManageUIReadonlyState 
	/// on a business object.  This method was just created to make the developer aware of this feature 
	/// through the sample applicaiton.
	/// </summary>
	/// <remarks></remarks>
	private void SetUIReadonly()
	{
		Customers.ManageUIReadOnlyState = ! this.chkIgnoreReadonly.Checked;

		//-- Set the controls enabled state since it will have already been disabled/enbaled from the
		//   automatic management.  If the management has been turned off, the controls will 
		//   remain in a disabled state.  Again, this does not need to be done in a normal operating
		//   environment and has been done in this application for sample purposes only.  If you do not 
		//   want the BO to manage the states, set the property on the control (IgnoreUIReadonlyState) or 
		//   BO (ManageUIReadonlyState) at design-time.
		this.txtFirstName.Enabled = this.chkIgnoreReadonly.Checked;
		this.txtMiddleName.Enabled = this.chkIgnoreReadonly.Checked;
		this.txtLastName.Enabled = this.chkIgnoreReadonly.Checked;
		this.txtAddress.Enabled = this.chkIgnoreReadonly.Checked;
		this.txtCity.Enabled = this.chkIgnoreReadonly.Checked;
		this.txtState.Enabled = this.chkIgnoreReadonly.Checked;
		this.txtPostal.Enabled = this.chkIgnoreReadonly.Checked;
	}

	/// <summary>
	/// Sets the enabled state of the editing buttons
	/// </summary>
	/// <remarks></remarks>
	private void SetButtonState()
	{
//INSTANT C# NOTE: The following VB 'Select Case' included range-type or non-constant 'Case' expressions and was converted to C# 'if-else' logic:
//		Select Case Customers.EditingState
//ORIGINAL LINE: Case MicroFour.StrataFrame.Business.BusinessEditingState.Idle
		if (Customers.EditingState == MicroFour.StrataFrame.Business.BusinessEditingState.Idle)
		{
				cmdAdd.Enabled = true;
				cmdEdit.Enabled = true;
				cmdDelete.Enabled = true;
				cmdSave.Enabled = false;
				cmdUndo.Enabled = false;
				cmdFirst.Visible = true;
				cmdPrevious.Visible = true;
				cmdNext.Visible = true;
				cmdLast.Visible = true;
				this.chkIgnoreReadonly.Enabled = true;

		}
//ORIGINAL LINE: Case Else
		else
		{
				cmdAdd.Enabled = false;
				cmdEdit.Enabled = false;
				cmdDelete.Enabled = false;
				cmdSave.Enabled = true;
				cmdUndo.Enabled = true;
				cmdFirst.Visible = false;
				cmdPrevious.Visible = false;
				cmdNext.Visible = false;
				cmdLast.Visible = false;
				this.chkIgnoreReadonly.Enabled = false;
		}
	}

#endregion

#region  Handled Events 

	protected void cmdFirst_Click(object sender, System.Web.UI.ImageClickEventArgs e)
	{
		Customers.Navigate(MicroFour.StrataFrame.Business.BusinessNavigationDirection.First);
	}

	protected void cmdLast_Click(object sender, System.Web.UI.ImageClickEventArgs e)
	{
		Customers.Navigate(MicroFour.StrataFrame.Business.BusinessNavigationDirection.Last);
	}

	protected void cmdNext_Click(object sender, System.Web.UI.ImageClickEventArgs e)
	{
        Customers.Navigate(MicroFour.StrataFrame.Business.BusinessNavigationDirection.Next);
	}

	protected void cmdPrevious_Click(object sender, System.Web.UI.ImageClickEventArgs e)
	{
		Customers.Navigate(MicroFour.StrataFrame.Business.BusinessNavigationDirection.Prior);
	}

	protected void cmdAdd_Click(object sender, System.EventArgs e)
	{
		Customers.Add();
		SetButtonState();
		txtFirstName.Focus();
	}

	protected void cmdEdit_Click(object sender, System.EventArgs e)
	{
		Customers.Edit();
		SetButtonState();
		txtFirstName.Focus();
	}

	protected void cmdDelete_Click(object sender, System.EventArgs e)
	{
		if (System.Windows.Forms.MessageBox.Show("Are you sure you want to delete this record?", "Delete Record?", System.Windows.Forms.MessageBoxButtons.YesNo, System.Windows.Forms.MessageBoxIcon.Question) == System.Windows.Forms.DialogResult.Yes)
		{
			Customers.DeleteCurrentRow(false);
			SetButtonState();
		}
	}

	protected void cmdSave_Click(object sender, System.EventArgs e)
	{
		//-- Establish Locals
//INSTANT C# NOTE: Commented this declaration since looping variables in 'foreach' loops are declared in the 'foreach' header in C#
//		MicroFour.StrataFrame.Business.BrokenRule loRule = null;
		string lcRules = "";
		string lcAddMsg = "";

		if (Customers.Save() == MicroFour.StrataFrame.Data.SaveUndoResult.Success)
		{
			SetButtonState();
		}
		else
		{
			foreach (MicroFour.StrataFrame.Business.BrokenRule loRule in Customers.BrokenRules.ToArray())
			{
				if (lcRules.Length > 0)
				{
					lcRules += "<br><br>";
				}

				lcRules += "<strong>" + Customers.GetFieldDescription(loRule.FieldName) + "</strong><br>";
				lcRules += loRule.Description.Replace("\r", "<br>");
			}

			if (lcAddMsg.Length > 0)
			{
				if (lcRules.Length > 0)
				{
					lcRules += "<br><br>";
				}

				lcRules += lcAddMsg;
			}

			//-- See if there are rules to add
			lblErrors.Text = "<br>" + this.GenerateWarningTable(lcRules) + "<br>";
			lblErrors.Visible = true;
		}
	}

	protected void cmdUndo_Click(object sender, System.EventArgs e)
	{
		Customers.Undo(MicroFour.StrataFrame.Business.BusinessUndoType.CurrentRowOnly);
		lblErrors.Visible = false;
		SetButtonState();
	}

#endregion

}
